/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class JSLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            this.launch(((IResource)object).getFullPath(), false, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IPath path = ((IFileEditorInput)input).getFile().getFullPath();
            this.launch(path, true, mode);
        } else {
            this.launch((IPath)new Path(input.getName()), true, mode);
        }
    }

    private void launch(IPath path, boolean current, String mode) {
        ILaunchConfiguration config;
        String ext = path.getFileExtension();
        if (("htm".equals(ext) || "html".equals(ext) || "xhtml".equals(ext)) && (config = this.findLaunchConfiguration(path, current, mode)) != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(IPath path, boolean current, String mode) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("serverType", -1) == 1) {
                    if (path != null && config.getAttribute("startActionType", -1) == 2 && path.toPortableString().equals(config.getAttribute("startPagePath", ""))) {
                        return config;
                    }
                    if (current && config.getAttribute("startActionType", -1) == 1) {
                        return config;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return this.createConfiguration(current ? null : path);
    }

    private ILaunchConfiguration createConfiguration(IPath path) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        try {
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(path != null ? path.lastSegment() : "Default"));
            JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, null);
            if (path != null) {
                wc.setAttribute("startActionType", 2);
                wc.setAttribute("startPagePath", path.toPortableString());
            }
            config = wc.doSave();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return config;
    }

    private ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.aptana.js.debug.core.webbrowserLaunchConfigurationType");
    }
}

